
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(6,'2023_08_11_053021_create_pam_cont_types_table',1),(7,'2023_08_11_054510_create_pam_cont_groups_table',1),(9,'2023_08_11_061615_create_pam_dedu_types_table',1),(10,'2023_08_11_061901_create_pam_dedu_groups_table',1),(12,'2023_08_11_062420_create_pam_earn_types_table',1),(13,'2023_08_11_062727_create_pam_earn_groups_table',1),(15,'2023_08_11_062956_create_pam_tax_years_table',1),(17,'2023_08_11_063250_create_pam_social_securities_table',1),(18,'2023_08_11_063252_create_pam_tax_tables_table',1),(19,'2023_08_11_063253_create_pam_tax_bands_table',1),(99,'2023_08_14_102738_create_pam_loans_table',2),(178,'2014_10_12_100000_create_password_reset_tokens_table',3),(179,'2014_10_12_100000_create_password_resets_table',3),(180,'2016_06_01_000001_create_oauth_auth_codes_table',3),(181,'2016_06_01_000002_create_oauth_access_tokens_table',3),(182,'2016_06_01_000003_create_oauth_refresh_tokens_table',3),(183,'2016_06_01_000004_create_oauth_clients_table',3),(184,'2016_06_01_000005_create_oauth_personal_access_clients_table',3),(185,'2019_08_19_000000_create_failed_jobs_table',3),(186,'2019_12_14_000001_create_personal_access_tokens_table',3),(187,'2023_08_11_060005_create_pam_cont_defs_table',3),(188,'2023_08_11_062140_create_pam_dedu_defs_table',3),(189,'2023_08_11_062738_create_pam_earn_defs_table',3),(190,'2023_08_11_063240_create_pam_pay_run_periods_table',3),(191,'2023_08_11_063300_create_pam_payrolls_table',3),(192,'2023_08_11_063321_create_pam_emps_table',3),(193,'2023_08_11_063843_create_pam_pay_runs_table',3),(194,'2023_08_11_070350_create_pam_pay_cont_defs_table',3),(195,'2023_08_11_070351_create_pam_pay_earn_defs_table',3),(196,'2023_08_11_070406_create_pam_pay_dedu_defs_table',3),(197,'2023_08_11_071038_create_pam_emp_dedu_defs_table',3),(198,'2023_08_11_071050_create_pam_emp_cont_defs_table',3),(199,'2023_08_11_071050_create_pam_emp_earn_defs_table',3),(200,'2023_08_11_071551_create_pam_payslips_table',3),(201,'2023_08_11_102738_create_pam_loans_table',3),(202,'2023_08_11_102739_create_pam_loan_payments_table',3),(203,'2023_08_11_121835_create_pam_payslip_dedus_table',3),(204,'2023_08_11_121840_create_pam_payslip_earns_table',3),(205,'2023_08_22_222715_create_permission_tables',3),(206,'2023_09_08_090149_create_pam_claims_table',3),(207,'2023_09_12_093855_create_pam_payslip_dedu_defs_table',3),(208,'2023_09_12_093930_create_pam_emp_ytd_totals_table ',3),(209,'2023_09_12_093930_create_pam_payslip_earn_defs_table',3),(210,'2023_11_05_135831_create_jobs_table',3),(211,'2023_11_29_131608_create_pam_approved_claims_table',3);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\Models\\User',1),(1,'App\\Models\\User',2),(1,'App\\Models\\User',3),(1,'App\\Models\\User',4),(1,'App\\Models\\User',6),(1,'App\\Models\\User',7),(1,'App\\Models\\User',8),(1,'App\\Models\\User',9),(1,'App\\Models\\User',10),(1,'App\\Models\\User',11),(1,'App\\Models\\User',12),(1,'App\\Models\\User',13),(1,'App\\Models\\User',14),(1,'App\\Models\\User',15),(1,'App\\Models\\User',16),(1,'App\\Models\\User',17),(1,'App\\Models\\User',18),(1,'App\\Models\\User',19),(1,'App\\Models\\User',20),(1,'App\\Models\\User',21);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_auth_codes_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `secret` varchar(100) DEFAULT NULL,
  `provider` varchar(255) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_approved_claims`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_approved_claims` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` bigint(20) unsigned NOT NULL,
  `earn_def_id` bigint(20) unsigned NOT NULL,
  `approved_on_payslip_id` bigint(20) unsigned DEFAULT NULL,
  `approved_on_pay_run_id` bigint(20) unsigned DEFAULT NULL,
  `aggregate_amount` double DEFAULT NULL,
  `payment_status` varchar(255) DEFAULT NULL,
  `paid_on_payslip_id` bigint(20) unsigned DEFAULT NULL,
  `paid_amount` double DEFAULT NULL,
  `comments` varchar(255) DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_approved_claims_created_by_foreign` (`created_by`),
  KEY `pam_approved_claims_updated_by_foreign` (`updated_by`),
  KEY `pam_approved_claims_emp_id_foreign` (`emp_id`),
  KEY `pam_approved_claims_earn_def_id_foreign` (`earn_def_id`),
  KEY `pam_approved_claims_approved_on_payslip_id_foreign` (`approved_on_payslip_id`),
  KEY `pam_approved_claims_approved_on_pay_run_id_foreign` (`approved_on_pay_run_id`),
  CONSTRAINT `pam_approved_claims_approved_on_pay_run_id_foreign` FOREIGN KEY (`approved_on_pay_run_id`) REFERENCES `pam_pay_runs` (`id`),
  CONSTRAINT `pam_approved_claims_approved_on_payslip_id_foreign` FOREIGN KEY (`approved_on_payslip_id`) REFERENCES `pam_payslips` (`id`),
  CONSTRAINT `pam_approved_claims_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_approved_claims_earn_def_id_foreign` FOREIGN KEY (`earn_def_id`) REFERENCES `pam_earn_defs` (`id`),
  CONSTRAINT `pam_approved_claims_emp_id_foreign` FOREIGN KEY (`emp_id`) REFERENCES `pam_emps` (`id`),
  CONSTRAINT `pam_approved_claims_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_approved_claims` WRITE;
/*!40000 ALTER TABLE `pam_approved_claims` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_approved_claims` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_claims`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_claims` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` bigint(20) unsigned NOT NULL,
  `earn_def_id` bigint(20) unsigned NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `units` varchar(255) DEFAULT NULL,
  `quantity` double DEFAULT NULL,
  `rate` double DEFAULT NULL,
  `claim_amount` double DEFAULT NULL,
  `supervisor_id` varchar(255) DEFAULT NULL,
  `workflow_status` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_date` date DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_claims_created_by_foreign` (`created_by`),
  KEY `pam_claims_updated_by_foreign` (`updated_by`),
  KEY `pam_claims_emp_id_foreign` (`emp_id`),
  KEY `pam_claims_earn_def_id_foreign` (`earn_def_id`),
  CONSTRAINT `pam_claims_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_claims_earn_def_id_foreign` FOREIGN KEY (`earn_def_id`) REFERENCES `pam_earn_defs` (`id`),
  CONSTRAINT `pam_claims_emp_id_foreign` FOREIGN KEY (`emp_id`) REFERENCES `pam_emps` (`id`),
  CONSTRAINT `pam_claims_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_claims` WRITE;
/*!40000 ALTER TABLE `pam_claims` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_claims` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_cont_defs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_cont_defs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `general_ledger_code` varchar(255) NOT NULL,
  `cont_type_id` bigint(20) unsigned NOT NULL,
  `cont_group_id` bigint(20) unsigned NOT NULL,
  `cont_type_code` varchar(255) NOT NULL,
  `cont_group_code` varchar(255) NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `employee_contribution_rate` decimal(15,2) DEFAULT NULL,
  `employer_contribution_rate` decimal(15,2) DEFAULT NULL,
  `employee_contribution_fixed_amount` decimal(15,2) DEFAULT NULL,
  `employer_contribution_fixed_amount` decimal(15,2) DEFAULT NULL,
  `employee_maximum_ceiling` decimal(15,2) DEFAULT NULL,
  `employer_maximum_ceiling` decimal(15,2) DEFAULT NULL,
  `recurrence_period_1` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_2` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_3` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_4` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_5` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_6` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_7` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_8` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_9` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_10` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_11` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_12` int(11) NOT NULL DEFAULT 0,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pam_cont_defs_code_unique` (`code`),
  UNIQUE KEY `pam_cont_defs_short_description_unique` (`short_description`),
  KEY `pam_cont_defs_created_by_foreign` (`created_by`),
  KEY `pam_cont_defs_updated_by_foreign` (`updated_by`),
  KEY `pam_cont_defs_cont_type_id_foreign` (`cont_type_id`),
  KEY `pam_cont_defs_cont_group_id_foreign` (`cont_group_id`),
  CONSTRAINT `pam_cont_defs_cont_group_id_foreign` FOREIGN KEY (`cont_group_id`) REFERENCES `pam_cont_groups` (`id`),
  CONSTRAINT `pam_cont_defs_cont_type_id_foreign` FOREIGN KEY (`cont_type_id`) REFERENCES `pam_cont_types` (`id`),
  CONSTRAINT `pam_cont_defs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_cont_defs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_cont_defs` WRITE;
/*!40000 ALTER TABLE `pam_cont_defs` DISABLE KEYS */;
INSERT INTO `pam_cont_defs` VALUES (1,'NAPSA','NAPSA',1,1,'SOCIALSECURITY','STATUTORY','NAPSA','NAPSA is a social security scheme that provides basic cover to all eligible employees in Zambia. The NAPSA Act No. 40 of 1996 of the Laws of Zambia established the National Pension Scheme Authority.',0.00,0.00,NULL,NULL,0.00,0.00,0,0,0,0,0,0,0,0,0,0,0,0,'active',11,11,'2023-12-01 12:08:23','2023-12-01 12:08:23'),(2,'SDL','SDL',2,1,'LEVY','STATUTORY','Skills Development Levy','Skills Development Levy',0.00,0.00,NULL,NULL,0.00,0.00,0,0,0,0,0,0,0,0,0,0,0,0,'active',11,11,'2023-12-01 12:08:23','2023-12-01 12:08:23'),(3,'PEL','PEL',2,1,'LEVY','STATUTORY','Personal Levy','Personal Levy',0.00,0.00,NULL,NULL,0.00,0.00,0,0,0,0,0,0,0,0,0,0,0,0,'active',11,11,'2023-12-01 12:08:23','2023-12-01 12:08:23');
/*!40000 ALTER TABLE `pam_cont_defs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_cont_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_cont_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `cont_group_parent_id` bigint(20) unsigned DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pam_cont_groups_code_unique` (`code`),
  UNIQUE KEY `pam_cont_groups_short_description_unique` (`short_description`),
  KEY `pam_cont_groups_created_by_foreign` (`created_by`),
  KEY `pam_cont_groups_updated_by_foreign` (`updated_by`),
  KEY `pam_cont_groups_cont_group_parent_id_foreign` (`cont_group_parent_id`),
  CONSTRAINT `pam_cont_groups_cont_group_parent_id_foreign` FOREIGN KEY (`cont_group_parent_id`) REFERENCES `pam_cont_groups` (`id`),
  CONSTRAINT `pam_cont_groups_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_cont_groups_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_cont_groups` WRITE;
/*!40000 ALTER TABLE `pam_cont_groups` DISABLE KEYS */;
INSERT INTO `pam_cont_groups` VALUES (1,'STATUTORY','Statutory','Statutory',NULL,'Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(2,'OTHER','Other','Other',NULL,'Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30');
/*!40000 ALTER TABLE `pam_cont_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_cont_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_cont_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `comment` text DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pam_cont_types_code_unique` (`code`),
  UNIQUE KEY `pam_cont_types_short_description_unique` (`short_description`),
  KEY `pam_cont_types_created_by_foreign` (`created_by`),
  KEY `pam_cont_types_updated_by_foreign` (`updated_by`),
  CONSTRAINT `pam_cont_types_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_cont_types_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_cont_types` WRITE;
/*!40000 ALTER TABLE `pam_cont_types` DISABLE KEYS */;
INSERT INTO `pam_cont_types` VALUES (1,'SOCIALSECURITY','Social Security','Social Security (NAPSA)',NULL,'Active',1,1,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(2,'LEVY','LEVY','LEVY',NULL,'Active',1,1,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(3,'UNION','Union','Union ',NULL,'Active',1,1,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(4,'PENSION','Pension Fund','Pension Fund',NULL,'Active',1,1,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(5,'MEDAID','Medical Aid','Medical Aid',NULL,'Active',1,1,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(6,'OTHER','Other','Other',NULL,'Active',1,1,'2023-11-10 09:23:30','2023-11-10 09:23:30');
/*!40000 ALTER TABLE `pam_cont_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_dedu_defs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_dedu_defs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `general_ledger_code` varchar(255) NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `cont_def_id` bigint(20) unsigned DEFAULT NULL,
  `dedu_type_id` bigint(20) unsigned NOT NULL,
  `dedu_group_id` bigint(20) unsigned NOT NULL,
  `dedu_type_code` varchar(255) NOT NULL,
  `dedu_group_code` varchar(255) NOT NULL,
  `percentage` decimal(8,2) DEFAULT NULL,
  `fixed_amount` decimal(8,2) DEFAULT NULL,
  `mode_of_calculation` varchar(255) NOT NULL,
  `calculation_basis` varchar(255) NOT NULL,
  `recurrence_period_1` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_2` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_3` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_4` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_5` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_6` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_7` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_8` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_9` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_10` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_11` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_12` int(11) NOT NULL DEFAULT 0,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pam_dedu_defs_code_unique` (`code`),
  UNIQUE KEY `pam_dedu_defs_short_description_unique` (`short_description`),
  KEY `pam_dedu_defs_cont_def_id_foreign` (`cont_def_id`),
  KEY `pam_dedu_defs_dedu_type_id_foreign` (`dedu_type_id`),
  KEY `pam_dedu_defs_created_by_foreign` (`created_by`),
  KEY `pam_dedu_defs_updated_by_foreign` (`updated_by`),
  KEY `pam_dedu_defs_dedu_group_id_foreign` (`dedu_group_id`),
  CONSTRAINT `pam_dedu_defs_cont_def_id_foreign` FOREIGN KEY (`cont_def_id`) REFERENCES `pam_cont_defs` (`id`),
  CONSTRAINT `pam_dedu_defs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_dedu_defs_dedu_group_id_foreign` FOREIGN KEY (`dedu_group_id`) REFERENCES `pam_dedu_groups` (`id`),
  CONSTRAINT `pam_dedu_defs_dedu_type_id_foreign` FOREIGN KEY (`dedu_type_id`) REFERENCES `pam_dedu_types` (`id`),
  CONSTRAINT `pam_dedu_defs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_dedu_defs` WRITE;
/*!40000 ALTER TABLE `pam_dedu_defs` DISABLE KEYS */;
INSERT INTO `pam_dedu_defs` VALUES (1,'PAYE','PAYE','Pay As You Earn','Pay As You Earn (PAYE) is a tax on employee\'s income. It is deducted from salaries and wages by employers who are registered with the Kenya Revenue Authority (KRA) and paid to the KRA on a monthly basis.',NULL,1,1,'INCTAX','STATUTORY',NULL,NULL,'fixed','gross',0,0,0,0,0,0,0,0,0,0,0,0,'active',19,19,'2023-12-01 12:08:23','2023-12-01 12:08:23'),(2,'NAPSA','NAPSA','NAPSA','NAPSA is a social security scheme that provides basic cover to all eligible employees in Zambia. The NAPSA Act No. 40 of 1996 of the Laws of Zambia established the National Pension Scheme Authority.',NULL,3,1,'SOCIALSECURITY','STATUTORY',NULL,NULL,'fixed','gross',0,0,0,0,0,0,0,0,0,0,0,0,'active',19,19,'2023-12-01 12:08:23','2023-12-01 12:08:23');
/*!40000 ALTER TABLE `pam_dedu_defs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_dedu_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_dedu_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `dedu_group_parent_id` bigint(20) unsigned DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pam_dedu_groups_code_unique` (`code`),
  UNIQUE KEY `pam_dedu_groups_short_description_unique` (`short_description`),
  KEY `pam_dedu_groups_created_by_foreign` (`created_by`),
  KEY `pam_dedu_groups_updated_by_foreign` (`updated_by`),
  KEY `pam_dedu_groups_dedu_group_parent_id_foreign` (`dedu_group_parent_id`),
  CONSTRAINT `pam_dedu_groups_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_dedu_groups_dedu_group_parent_id_foreign` FOREIGN KEY (`dedu_group_parent_id`) REFERENCES `pam_dedu_types` (`id`),
  CONSTRAINT `pam_dedu_groups_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_dedu_groups` WRITE;
/*!40000 ALTER TABLE `pam_dedu_groups` DISABLE KEYS */;
INSERT INTO `pam_dedu_groups` VALUES (1,'STATUTORY','Statutory','Statutory',NULL,'Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(2,'OTHER','Other','Other',NULL,'Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30');
/*!40000 ALTER TABLE `pam_dedu_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_dedu_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_dedu_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pam_dedu_types_code_unique` (`code`),
  UNIQUE KEY `pam_dedu_types_short_description_unique` (`short_description`),
  KEY `pam_dedu_types_created_by_foreign` (`created_by`),
  KEY `pam_dedu_types_updated_by_foreign` (`updated_by`),
  CONSTRAINT `pam_dedu_types_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_dedu_types_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_dedu_types` WRITE;
/*!40000 ALTER TABLE `pam_dedu_types` DISABLE KEYS */;
INSERT INTO `pam_dedu_types` VALUES (1,'INCTAX','Income Tax','Income Tax (PAYE)','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(2,'ADDTAX','Additional Tax','Additional Tax (PAYE)','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(3,'SOCIALSECURITY','Social Security','Social Security (NAPSA)','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(4,'UNION','Union Dues','Union Dues','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(5,'MEDICAL','Medical','Medical','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(6,'OTHER','Other Deductions','Other Deductions','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(7,'LOAN','Loan','Loan','active',1,1,'2023-11-27 09:37:21','2023-11-27 09:38:29');
/*!40000 ALTER TABLE `pam_dedu_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_earn_defs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_earn_defs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `general_ledger_code` varchar(255) NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `earn_type_id` bigint(20) unsigned NOT NULL,
  `earn_group_id` bigint(20) unsigned NOT NULL,
  `earn_type_code` varchar(255) NOT NULL,
  `earn_group_code` varchar(255) NOT NULL,
  `percentage` decimal(8,2) DEFAULT NULL,
  `fixed_amount` decimal(8,2) DEFAULT NULL,
  `mode_of_calculation` varchar(255) NOT NULL,
  `overtime_rate` decimal(8,2) DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `recurrence_period_1` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_2` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_3` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_4` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_5` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_6` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_7` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_8` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_9` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_10` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_11` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_12` int(11) NOT NULL DEFAULT 0,
  `can_prorata` int(11) NOT NULL DEFAULT 0,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pam_earn_defs_code_unique` (`code`),
  UNIQUE KEY `pam_earn_defs_short_description_unique` (`short_description`),
  KEY `pam_earn_defs_earn_type_id_foreign` (`earn_type_id`),
  KEY `pam_earn_defs_created_by_foreign` (`created_by`),
  KEY `pam_earn_defs_updated_by_foreign` (`updated_by`),
  KEY `pam_earn_defs_earn_group_id_foreign` (`earn_group_id`),
  CONSTRAINT `pam_earn_defs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_earn_defs_earn_group_id_foreign` FOREIGN KEY (`earn_group_id`) REFERENCES `pam_earn_groups` (`id`),
  CONSTRAINT `pam_earn_defs_earn_type_id_foreign` FOREIGN KEY (`earn_type_id`) REFERENCES `pam_earn_types` (`id`),
  CONSTRAINT `pam_earn_defs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_earn_defs` WRITE;
/*!40000 ALTER TABLE `pam_earn_defs` DISABLE KEYS */;
INSERT INTO `pam_earn_defs` VALUES (1,'BASICPAY','BASICPAY','Basic Pay','Basic Pay is the amount of money an employee receives before any extras are added or taken off, such as bonuses, overtime, tax, and deductions. It does not include bonuses, overtime and any other allowances.',1,1,'BASIC','TAXABLE',NULL,NULL,'fixed',NULL,'active',0,0,0,0,0,0,0,0,0,0,0,0,0,18,18,'2023-12-01 12:08:23','2023-12-01 12:08:23');
/*!40000 ALTER TABLE `pam_earn_defs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_earn_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_earn_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `earn_group_parent_id` bigint(20) unsigned DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pam_earn_groups_code_unique` (`code`),
  UNIQUE KEY `pam_earn_groups_short_description_unique` (`short_description`),
  KEY `pam_earn_groups_created_by_foreign` (`created_by`),
  KEY `pam_earn_groups_updated_by_foreign` (`updated_by`),
  KEY `pam_earn_groups_earn_group_parent_id_foreign` (`earn_group_parent_id`),
  CONSTRAINT `pam_earn_groups_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_earn_groups_earn_group_parent_id_foreign` FOREIGN KEY (`earn_group_parent_id`) REFERENCES `pam_earn_types` (`id`),
  CONSTRAINT `pam_earn_groups_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_earn_groups` WRITE;
/*!40000 ALTER TABLE `pam_earn_groups` DISABLE KEYS */;
INSERT INTO `pam_earn_groups` VALUES (1,NULL,'TAXABLE','Taxable Income','Taxable Income','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(2,NULL,'NONTAXABLE','Non Taxable Income','Non Taxable Income','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(3,NULL,'OTHER','Other','Other','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30');
/*!40000 ALTER TABLE `pam_earn_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_earn_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_earn_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pam_earn_types_code_unique` (`code`),
  UNIQUE KEY `pam_earn_types_short_description_unique` (`short_description`),
  KEY `pam_earn_types_created_by_foreign` (`created_by`),
  KEY `pam_earn_types_updated_by_foreign` (`updated_by`),
  CONSTRAINT `pam_earn_types_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_earn_types_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_earn_types` WRITE;
/*!40000 ALTER TABLE `pam_earn_types` DISABLE KEYS */;
INSERT INTO `pam_earn_types` VALUES (1,'BASIC','Basic Income','Basic Income','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(2,'INCPAYE','Other Income - Taxable','Other Income - Taxable','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(3,'INCNOPAYE','Other Income - Non-Taxable','Other Income - Non-Taxable)','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(4,'PENSION','Pension','Pension','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(5,'LEAVEALL','Leave Allowance','Leave Allowance','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(6,'LEAVEPAY','Leave Pay','Leave Pay','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(7,'OVERTIME','Overtime','Overtime','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(8,'BONUS','Bonus','Bonus','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(9,'COMMISSION','Commission','Commission','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(10,'OTHER','Other Allowances','Other Allowances','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(11,'GRATUITY','Gratuity','Gratuity','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30'),(12,'CLAIM','Claim','Claim','Active',4,4,'2023-11-10 09:23:30','2023-11-10 09:23:30');
/*!40000 ALTER TABLE `pam_earn_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_emp_cont_defs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_emp_cont_defs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cont_def_id` bigint(20) unsigned NOT NULL,
  `cont_def_code` varchar(255) NOT NULL,
  `emp_id` bigint(20) unsigned NOT NULL,
  `payroll_id` bigint(20) unsigned NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `recurrence_period_1` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_2` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_3` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_4` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_5` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_6` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_7` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_8` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_9` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_10` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_11` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_12` int(11) NOT NULL DEFAULT 0,
  `start_date` datetime NOT NULL,
  `end_date` datetime DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_emp_cont_defs_created_by_foreign` (`created_by`),
  KEY `pam_emp_cont_defs_updated_by_foreign` (`updated_by`),
  KEY `pam_emp_cont_defs_cont_def_id_foreign` (`cont_def_id`),
  KEY `pam_emp_cont_defs_payroll_id_foreign` (`payroll_id`),
  CONSTRAINT `pam_emp_cont_defs_cont_def_id_foreign` FOREIGN KEY (`cont_def_id`) REFERENCES `pam_cont_defs` (`id`),
  CONSTRAINT `pam_emp_cont_defs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_emp_cont_defs_payroll_id_foreign` FOREIGN KEY (`payroll_id`) REFERENCES `pam_payrolls` (`id`),
  CONSTRAINT `pam_emp_cont_defs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_emp_cont_defs` WRITE;
/*!40000 ALTER TABLE `pam_emp_cont_defs` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_emp_cont_defs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_emp_dedu_defs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_emp_dedu_defs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `dedu_def_id` bigint(20) unsigned NOT NULL,
  `dedu_def_code` varchar(255) NOT NULL,
  `emp_id` bigint(20) unsigned NOT NULL,
  `payroll_id` bigint(20) unsigned NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `recurrence_period_1` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_2` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_3` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_4` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_5` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_6` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_7` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_8` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_9` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_10` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_11` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_12` int(11) NOT NULL DEFAULT 0,
  `start_date` datetime NOT NULL,
  `end_date` datetime DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_emp_dedu_defs_created_by_foreign` (`created_by`),
  KEY `pam_emp_dedu_defs_updated_by_foreign` (`updated_by`),
  KEY `pam_emp_dedu_defs_dedu_def_id_foreign` (`dedu_def_id`),
  KEY `pam_emp_dedu_defs_payroll_id_foreign` (`payroll_id`),
  KEY `pam_emp_dedu_defs_emp_id_foreign` (`emp_id`),
  CONSTRAINT `pam_emp_dedu_defs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_emp_dedu_defs_dedu_def_id_foreign` FOREIGN KEY (`dedu_def_id`) REFERENCES `pam_dedu_defs` (`id`),
  CONSTRAINT `pam_emp_dedu_defs_emp_id_foreign` FOREIGN KEY (`emp_id`) REFERENCES `pam_emps` (`id`),
  CONSTRAINT `pam_emp_dedu_defs_payroll_id_foreign` FOREIGN KEY (`payroll_id`) REFERENCES `pam_payrolls` (`id`),
  CONSTRAINT `pam_emp_dedu_defs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_emp_dedu_defs` WRITE;
/*!40000 ALTER TABLE `pam_emp_dedu_defs` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_emp_dedu_defs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_emp_earn_defs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_emp_earn_defs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `earn_def_id` bigint(20) unsigned NOT NULL,
  `earn_def_code` varchar(255) NOT NULL,
  `emp_id` bigint(20) unsigned NOT NULL,
  `payroll_id` bigint(20) unsigned NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `recurrence_period_1` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_2` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_3` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_4` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_5` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_6` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_7` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_8` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_9` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_10` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_11` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_12` int(11) NOT NULL DEFAULT 0,
  `start_date` datetime NOT NULL,
  `end_date` datetime DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_emp_earn_defs_created_by_foreign` (`created_by`),
  KEY `pam_emp_earn_defs_updated_by_foreign` (`updated_by`),
  KEY `pam_emp_earn_defs_earn_def_id_foreign` (`earn_def_id`),
  KEY `pam_emp_earn_defs_payroll_id_foreign` (`payroll_id`),
  CONSTRAINT `pam_emp_earn_defs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_emp_earn_defs_earn_def_id_foreign` FOREIGN KEY (`earn_def_id`) REFERENCES `pam_earn_defs` (`id`),
  CONSTRAINT `pam_emp_earn_defs_payroll_id_foreign` FOREIGN KEY (`payroll_id`) REFERENCES `pam_payrolls` (`id`),
  CONSTRAINT `pam_emp_earn_defs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_emp_earn_defs` WRITE;
/*!40000 ALTER TABLE `pam_emp_earn_defs` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_emp_earn_defs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_emp_ytd_totals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_emp_ytd_totals` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` bigint(20) unsigned NOT NULL,
  `man_number` varchar(255) NOT NULL,
  `tax_year_id` bigint(20) unsigned NOT NULL,
  `tax_year_code` int(11) NOT NULL,
  `ytd_basic_pay` decimal(8,2) NOT NULL,
  `ytd_taxable_pay` decimal(8,2) NOT NULL,
  `ytd_non_taxable_pay` decimal(8,2) NOT NULL,
  `ytd_gross_pay` decimal(8,2) NOT NULL,
  `ytd_deductions` decimal(8,2) NOT NULL,
  `ytd_tax` decimal(8,2) NOT NULL,
  `ytd_net_pay` decimal(8,2) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_emp_ytd_totals_created_by_foreign` (`created_by`),
  KEY `pam_emp_ytd_totals_updated_by_foreign` (`updated_by`),
  KEY `pam_emp_ytd_totals_emp_id_foreign` (`emp_id`),
  KEY `pam_emp_ytd_totals_tax_year_id_foreign` (`tax_year_id`),
  CONSTRAINT `pam_emp_ytd_totals_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_emp_ytd_totals_emp_id_foreign` FOREIGN KEY (`emp_id`) REFERENCES `pam_emps` (`id`),
  CONSTRAINT `pam_emp_ytd_totals_tax_year_id_foreign` FOREIGN KEY (`tax_year_id`) REFERENCES `pam_tax_years` (`id`),
  CONSTRAINT `pam_emp_ytd_totals_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_emp_ytd_totals` WRITE;
/*!40000 ALTER TABLE `pam_emp_ytd_totals` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_emp_ytd_totals` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_emps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_emps` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payroll_id` bigint(20) unsigned NOT NULL,
  `man_number` varchar(255) NOT NULL,
  `national_id` varchar(255) NOT NULL,
  `first_name` varchar(255) NOT NULL,
  `middle_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) NOT NULL,
  `gender` varchar(255) NOT NULL,
  `date_of_birth` datetime NOT NULL,
  `basic_pay` decimal(8,2) NOT NULL,
  `email` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pam_emps_man_number_unique` (`man_number`),
  UNIQUE KEY `pam_emps_national_id_unique` (`national_id`),
  KEY `pam_emps_created_by_foreign` (`created_by`),
  KEY `pam_emps_updated_by_foreign` (`updated_by`),
  KEY `pam_emps_payroll_id_foreign` (`payroll_id`),
  CONSTRAINT `pam_emps_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_emps_payroll_id_foreign` FOREIGN KEY (`payroll_id`) REFERENCES `pam_payrolls` (`id`),
  CONSTRAINT `pam_emps_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_emps` WRITE;
/*!40000 ALTER TABLE `pam_emps` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_emps` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_loan_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_loan_payments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` bigint(20) unsigned NOT NULL,
  `loan_id` bigint(20) unsigned NOT NULL,
  `pay_run_id` bigint(20) unsigned NOT NULL,
  `pay_run_period_id` bigint(20) unsigned NOT NULL,
  `dedu_def_id` bigint(20) unsigned NOT NULL,
  `dedu_def_code` varchar(255) NOT NULL,
  `dedu_group_code` varchar(255) NOT NULL,
  `dedu_type_code` varchar(255) NOT NULL,
  `man_number` varchar(255) NOT NULL,
  `principal_amount` decimal(8,2) NOT NULL,
  `interest_amount` decimal(8,2) NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `payment_date` datetime NOT NULL,
  `payment_period` datetime NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_loan_payments_pay_run_id_foreign` (`pay_run_id`),
  KEY `pam_loan_payments_pay_run_period_id_foreign` (`pay_run_period_id`),
  KEY `pam_loan_payments_created_by_foreign` (`created_by`),
  KEY `pam_loan_payments_updated_by_foreign` (`updated_by`),
  KEY `pam_loan_payments_dedu_def_id_foreign` (`dedu_def_id`),
  KEY `pam_loan_payments_emp_id_foreign` (`emp_id`),
  KEY `pam_loan_payments_loan_id_foreign` (`loan_id`),
  CONSTRAINT `pam_loan_payments_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_loan_payments_dedu_def_id_foreign` FOREIGN KEY (`dedu_def_id`) REFERENCES `pam_dedu_defs` (`id`),
  CONSTRAINT `pam_loan_payments_emp_id_foreign` FOREIGN KEY (`emp_id`) REFERENCES `pam_emps` (`id`),
  CONSTRAINT `pam_loan_payments_loan_id_foreign` FOREIGN KEY (`loan_id`) REFERENCES `pam_loans` (`id`),
  CONSTRAINT `pam_loan_payments_pay_run_id_foreign` FOREIGN KEY (`pay_run_id`) REFERENCES `pam_pay_runs` (`id`),
  CONSTRAINT `pam_loan_payments_pay_run_period_id_foreign` FOREIGN KEY (`pay_run_period_id`) REFERENCES `pam_pay_run_periods` (`id`),
  CONSTRAINT `pam_loan_payments_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_loan_payments` WRITE;
/*!40000 ALTER TABLE `pam_loan_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_loan_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_loans` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `dedu_def_id` bigint(20) unsigned NOT NULL,
  `emp_id` bigint(20) unsigned NOT NULL,
  `dedu_def_code` varchar(255) NOT NULL,
  `dedu_type_code` varchar(255) NOT NULL,
  `dedu_group_code` varchar(255) NOT NULL,
  `man_number` varchar(255) NOT NULL,
  `tenure` int(11) NOT NULL,
  `principal_amount` decimal(8,2) NOT NULL,
  `interest_amount` decimal(8,2) NOT NULL,
  `loan_amount` decimal(8,2) NOT NULL,
  `monthly_instalment` decimal(8,2) NOT NULL,
  `monthly_instalment_deducted` decimal(8,2) NOT NULL,
  `interest_paid_to_date` decimal(8,2) NOT NULL,
  `principal_paid_to_date` decimal(8,2) NOT NULL,
  `total_paid_to_date` decimal(8,2) NOT NULL,
  `loan_balance_amount` decimal(8,2) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date DEFAULT NULL,
  `last_payment_date` date NOT NULL,
  `next_payment_date` date DEFAULT NULL,
  `number_of_payments` int(11) DEFAULT NULL,
  `number_of_payments_made` int(11) DEFAULT NULL,
  `number_of_payments_remaining` int(11) DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_loans_created_by_foreign` (`created_by`),
  KEY `pam_loans_updated_by_foreign` (`updated_by`),
  KEY `pam_loans_dedu_def_id_foreign` (`dedu_def_id`),
  KEY `pam_loans_emp_id_foreign` (`emp_id`),
  CONSTRAINT `pam_loans_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_loans_dedu_def_id_foreign` FOREIGN KEY (`dedu_def_id`) REFERENCES `pam_dedu_defs` (`id`),
  CONSTRAINT `pam_loans_emp_id_foreign` FOREIGN KEY (`emp_id`) REFERENCES `pam_emps` (`id`),
  CONSTRAINT `pam_loans_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_loans` WRITE;
/*!40000 ALTER TABLE `pam_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_loans` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_pay_cont_defs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_pay_cont_defs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cont_def_code` varchar(255) NOT NULL,
  `cont_def_id` bigint(20) unsigned NOT NULL,
  `payroll_id` bigint(20) unsigned NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `frequency` int(11) DEFAULT NULL,
  `employee_percentage` decimal(8,2) DEFAULT NULL,
  `employer_percentage` decimal(8,2) DEFAULT NULL,
  `employee_fixed_amount` decimal(8,2) DEFAULT NULL,
  `employer_fixed_amount` decimal(8,2) DEFAULT NULL,
  `mode_of_calculation` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_pay_cont_defs_created_by_foreign` (`created_by`),
  KEY `pam_pay_cont_defs_updated_by_foreign` (`updated_by`),
  KEY `pam_pay_cont_defs_cont_def_id_foreign` (`cont_def_id`),
  KEY `pam_pay_cont_defs_payroll_id_foreign` (`payroll_id`),
  CONSTRAINT `pam_pay_cont_defs_cont_def_id_foreign` FOREIGN KEY (`cont_def_id`) REFERENCES `pam_cont_defs` (`id`),
  CONSTRAINT `pam_pay_cont_defs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_pay_cont_defs_payroll_id_foreign` FOREIGN KEY (`payroll_id`) REFERENCES `pam_payrolls` (`id`),
  CONSTRAINT `pam_pay_cont_defs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_pay_cont_defs` WRITE;
/*!40000 ALTER TABLE `pam_pay_cont_defs` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_pay_cont_defs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_pay_dedu_defs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_pay_dedu_defs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `dedu_def_id` bigint(20) unsigned NOT NULL,
  `dedu_def_code` varchar(255) NOT NULL,
  `payroll_id` bigint(20) unsigned NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `percentage` decimal(8,2) DEFAULT NULL,
  `fixed_amount` decimal(8,2) DEFAULT NULL,
  `mode_of_calculation` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_pay_dedu_defs_created_by_foreign` (`created_by`),
  KEY `pam_pay_dedu_defs_updated_by_foreign` (`updated_by`),
  KEY `pam_pay_dedu_defs_dedu_def_id_foreign` (`dedu_def_id`),
  KEY `pam_pay_dedu_defs_payroll_id_foreign` (`payroll_id`),
  CONSTRAINT `pam_pay_dedu_defs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_pay_dedu_defs_dedu_def_id_foreign` FOREIGN KEY (`dedu_def_id`) REFERENCES `pam_dedu_defs` (`id`),
  CONSTRAINT `pam_pay_dedu_defs_payroll_id_foreign` FOREIGN KEY (`payroll_id`) REFERENCES `pam_payrolls` (`id`),
  CONSTRAINT `pam_pay_dedu_defs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_pay_dedu_defs` WRITE;
/*!40000 ALTER TABLE `pam_pay_dedu_defs` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_pay_dedu_defs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_pay_earn_defs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_pay_earn_defs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `earn_def_id` bigint(20) unsigned NOT NULL,
  `earn_def_code` varchar(255) NOT NULL,
  `payroll_id` bigint(20) unsigned NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `percentage` decimal(8,2) DEFAULT NULL,
  `fixed_amount` decimal(8,2) DEFAULT NULL,
  `mode_of_calculation` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_pay_earn_defs_created_by_foreign` (`created_by`),
  KEY `pam_pay_earn_defs_updated_by_foreign` (`updated_by`),
  KEY `pam_pay_earn_defs_earn_def_id_foreign` (`earn_def_id`),
  KEY `pam_pay_earn_defs_payroll_id_foreign` (`payroll_id`),
  CONSTRAINT `pam_pay_earn_defs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_pay_earn_defs_earn_def_id_foreign` FOREIGN KEY (`earn_def_id`) REFERENCES `pam_earn_defs` (`id`),
  CONSTRAINT `pam_pay_earn_defs_payroll_id_foreign` FOREIGN KEY (`payroll_id`) REFERENCES `pam_payrolls` (`id`),
  CONSTRAINT `pam_pay_earn_defs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_pay_earn_defs` WRITE;
/*!40000 ALTER TABLE `pam_pay_earn_defs` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_pay_earn_defs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_pay_run_periods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_pay_run_periods` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `period_status` varchar(255) NOT NULL,
  `processing_status` varchar(255) NOT NULL,
  `capture_status` varchar(255) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `tax_year_id` bigint(20) unsigned NOT NULL,
  `calendar_year` bigint(20) unsigned NOT NULL,
  `calendar_month` bigint(20) unsigned NOT NULL,
  `calendar_days_in_period` bigint(20) unsigned NOT NULL,
  `work_days_in_period` bigint(20) unsigned NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_pay_run_periods_created_by_foreign` (`created_by`),
  KEY `pam_pay_run_periods_updated_by_foreign` (`updated_by`),
  KEY `pam_pay_run_periods_tax_year_id_foreign` (`tax_year_id`),
  CONSTRAINT `pam_pay_run_periods_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_pay_run_periods_tax_year_id_foreign` FOREIGN KEY (`tax_year_id`) REFERENCES `pam_tax_years` (`id`),
  CONSTRAINT `pam_pay_run_periods_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_pay_run_periods` WRITE;
/*!40000 ALTER TABLE `pam_pay_run_periods` DISABLE KEYS */;
INSERT INTO `pam_pay_run_periods` VALUES (1,'Active','Pending','Open','2023-01-01 00:00:00','2023-01-31 23:59:59',2,2023,1,31,31,2,2,'2023-12-12 10:39:06','2023-12-12 10:39:06'),(2,'Active','Pending','Open','2023-02-01 00:00:00','2023-02-28 23:59:59',2,2023,2,28,28,2,2,'2023-12-12 10:39:06','2023-12-12 10:39:06'),(3,'Active','Pending','Open','2023-03-01 00:00:00','2023-03-31 23:59:59',2,2023,3,31,31,2,2,'2023-12-12 10:39:06','2023-12-12 10:39:06'),(4,'Active','Pending','Open','2023-04-01 00:00:00','2023-04-30 23:59:59',2,2023,4,30,30,2,2,'2023-12-12 10:39:06','2023-12-12 10:39:06'),(5,'Active','Pending','Open','2023-05-01 00:00:00','2023-05-31 23:59:59',2,2023,5,31,31,2,2,'2023-12-12 10:39:06','2023-12-12 10:39:06'),(6,'Active','Pending','Open','2023-06-01 00:00:00','2023-06-30 23:59:59',2,2023,6,30,30,2,2,'2023-12-12 10:39:06','2023-12-12 10:39:06'),(7,'Active','Pending','Open','2023-07-01 00:00:00','2023-07-31 23:59:59',2,2023,7,31,31,2,2,'2023-12-12 10:39:06','2023-12-12 10:39:06'),(8,'Active','Pending','Open','2023-08-01 00:00:00','2023-08-31 23:59:59',2,2023,8,31,31,2,2,'2023-12-12 10:39:06','2023-12-12 10:39:06'),(9,'Active','Pending','Open','2023-09-01 00:00:00','2023-09-30 23:59:59',2,2023,9,30,30,2,2,'2023-12-12 10:39:06','2023-12-12 10:39:06'),(10,'Active','Pending','Open','2023-10-01 00:00:00','2023-10-31 23:59:59',2,2023,10,31,31,2,2,'2023-12-12 10:39:06','2023-12-12 10:39:06'),(11,'Active','Pending','Open','2023-11-01 00:00:00','2023-11-30 23:59:59',2,2023,11,30,30,2,2,'2023-12-12 10:39:06','2023-12-12 10:39:06'),(12,'Active','Pending','Open','2023-12-01 00:00:00','2023-12-31 23:59:59',2,2023,12,31,31,2,2,'2023-12-12 10:39:06','2023-12-12 10:39:06');
/*!40000 ALTER TABLE `pam_pay_run_periods` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_pay_runs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_pay_runs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payroll_id` bigint(20) unsigned NOT NULL,
  `tax_table_id` bigint(20) unsigned NOT NULL,
  `social_security_id` bigint(20) unsigned DEFAULT NULL,
  `pay_run_period_id` bigint(20) unsigned DEFAULT NULL,
  `prev_pay_run_id` bigint(20) unsigned DEFAULT NULL,
  `next_pay_run_id` bigint(20) unsigned DEFAULT NULL,
  `pay_run_status` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `transaction_date` datetime DEFAULT NULL,
  `actual_processing_date` datetime DEFAULT NULL,
  `release_to_ess` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_pay_runs_created_by_foreign` (`created_by`),
  KEY `pam_pay_runs_updated_by_foreign` (`updated_by`),
  KEY `pam_pay_runs_payroll_id_foreign` (`payroll_id`),
  KEY `pam_pay_runs_pay_run_period_id_foreign` (`pay_run_period_id`),
  KEY `pam_pay_runs_prev_pay_run_id_foreign` (`prev_pay_run_id`),
  KEY `pam_pay_runs_next_pay_run_id_foreign` (`next_pay_run_id`),
  KEY `pam_pay_runs_tax_table_id_foreign` (`tax_table_id`),
  KEY `pam_pay_runs_social_security_id_foreign` (`social_security_id`),
  CONSTRAINT `pam_pay_runs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_pay_runs_next_pay_run_id_foreign` FOREIGN KEY (`next_pay_run_id`) REFERENCES `pam_pay_runs` (`id`),
  CONSTRAINT `pam_pay_runs_pay_run_period_id_foreign` FOREIGN KEY (`pay_run_period_id`) REFERENCES `pam_pay_run_periods` (`id`),
  CONSTRAINT `pam_pay_runs_payroll_id_foreign` FOREIGN KEY (`payroll_id`) REFERENCES `pam_payrolls` (`id`),
  CONSTRAINT `pam_pay_runs_prev_pay_run_id_foreign` FOREIGN KEY (`prev_pay_run_id`) REFERENCES `pam_pay_runs` (`id`),
  CONSTRAINT `pam_pay_runs_social_security_id_foreign` FOREIGN KEY (`social_security_id`) REFERENCES `pam_social_securities` (`id`),
  CONSTRAINT `pam_pay_runs_tax_table_id_foreign` FOREIGN KEY (`tax_table_id`) REFERENCES `pam_tax_tables` (`id`),
  CONSTRAINT `pam_pay_runs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_pay_runs` WRITE;
/*!40000 ALTER TABLE `pam_pay_runs` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_pay_runs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_payrolls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_payrolls` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `short_description` varchar(255) NOT NULL,
  `long_description` longtext NOT NULL,
  `working_days` int(11) NOT NULL DEFAULT 0,
  `start_date` datetime NOT NULL,
  `current_period_year` bigint(20) unsigned DEFAULT NULL,
  `current_period_month` bigint(20) unsigned DEFAULT NULL,
  `current_pay_run_id` bigint(20) unsigned DEFAULT NULL,
  `current_social_security_id` bigint(20) unsigned DEFAULT NULL,
  `current_tax_table_id` bigint(20) unsigned DEFAULT NULL,
  `comments` longtext DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `earnings` int(11) NOT NULL DEFAULT 0,
  `deductions` int(11) NOT NULL DEFAULT 0,
  `contributions` int(11) NOT NULL DEFAULT 0,
  `pension` int(11) NOT NULL DEFAULT 0,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pam_payrolls_code_unique` (`code`),
  UNIQUE KEY `pam_payrolls_short_description_unique` (`short_description`),
  KEY `pam_payrolls_created_by_foreign` (`created_by`),
  KEY `pam_payrolls_updated_by_foreign` (`updated_by`),
  KEY `pam_payrolls_current_social_security_id_foreign` (`current_social_security_id`),
  KEY `pam_payrolls_current_tax_table_id_foreign` (`current_tax_table_id`),
  CONSTRAINT `pam_payrolls_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_payrolls_current_social_security_id_foreign` FOREIGN KEY (`current_social_security_id`) REFERENCES `pam_social_securities` (`id`),
  CONSTRAINT `pam_payrolls_current_tax_table_id_foreign` FOREIGN KEY (`current_tax_table_id`) REFERENCES `pam_tax_tables` (`id`),
  CONSTRAINT `pam_payrolls_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_payrolls` WRITE;
/*!40000 ALTER TABLE `pam_payrolls` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_payrolls` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_payslip_dedu_defs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_payslip_dedu_defs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pay_run_id` bigint(20) unsigned NOT NULL,
  `dedu_def_id` bigint(20) unsigned NOT NULL,
  `dedu_def_code` varchar(255) NOT NULL,
  `payslip_id` bigint(20) unsigned NOT NULL,
  `emp_id` bigint(20) unsigned NOT NULL,
  `man_number` varchar(255) NOT NULL,
  `loan_id` bigint(20) unsigned DEFAULT NULL,
  `units` decimal(8,2) NOT NULL,
  `emp_rate` decimal(8,2) NOT NULL,
  `input_amount` decimal(8,2) NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `recurrence_period_1` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_2` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_3` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_4` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_5` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_6` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_7` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_8` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_9` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_10` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_11` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_12` int(11) NOT NULL DEFAULT 0,
  `mandatory` tinyint(1) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime DEFAULT NULL,
  `dedu_group_code` varchar(255) NOT NULL,
  `dedu_type_code` varchar(255) NOT NULL,
  `pay_run_period_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_payslip_dedu_defs_pay_run_id_foreign` (`pay_run_id`),
  KEY `pam_payslip_dedu_defs_pay_run_period_id_foreign` (`pay_run_period_id`),
  KEY `pam_payslip_dedu_defs_created_by_foreign` (`created_by`),
  KEY `pam_payslip_dedu_defs_updated_by_foreign` (`updated_by`),
  KEY `pam_payslip_dedu_defs_dedu_def_id_foreign` (`dedu_def_id`),
  KEY `pam_payslip_dedu_defs_payslip_id_foreign` (`payslip_id`),
  KEY `pam_payslip_dedu_defs_emp_id_foreign` (`emp_id`),
  KEY `pam_payslip_dedu_defs_loan_id_foreign` (`loan_id`),
  CONSTRAINT `pam_payslip_dedu_defs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_payslip_dedu_defs_dedu_def_id_foreign` FOREIGN KEY (`dedu_def_id`) REFERENCES `pam_dedu_defs` (`id`),
  CONSTRAINT `pam_payslip_dedu_defs_emp_id_foreign` FOREIGN KEY (`emp_id`) REFERENCES `pam_emps` (`id`),
  CONSTRAINT `pam_payslip_dedu_defs_loan_id_foreign` FOREIGN KEY (`loan_id`) REFERENCES `pam_loans` (`id`),
  CONSTRAINT `pam_payslip_dedu_defs_pay_run_id_foreign` FOREIGN KEY (`pay_run_id`) REFERENCES `pam_pay_runs` (`id`),
  CONSTRAINT `pam_payslip_dedu_defs_pay_run_period_id_foreign` FOREIGN KEY (`pay_run_period_id`) REFERENCES `pam_pay_run_periods` (`id`),
  CONSTRAINT `pam_payslip_dedu_defs_payslip_id_foreign` FOREIGN KEY (`payslip_id`) REFERENCES `pam_payslips` (`id`),
  CONSTRAINT `pam_payslip_dedu_defs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_payslip_dedu_defs` WRITE;
/*!40000 ALTER TABLE `pam_payslip_dedu_defs` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_payslip_dedu_defs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_payslip_dedus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_payslip_dedus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pay_run_id` bigint(20) unsigned NOT NULL,
  `dedu_def_id` bigint(20) unsigned NOT NULL,
  `dedu_def_code` varchar(255) NOT NULL,
  `payslip_id` bigint(20) unsigned NOT NULL,
  `loan_id` bigint(20) unsigned DEFAULT NULL,
  `emp_id` bigint(20) unsigned NOT NULL,
  `man_number` varchar(255) NOT NULL,
  `units` decimal(8,2) NOT NULL,
  `fixed_amount` decimal(8,2) NOT NULL,
  `recurrence_amount` decimal(8,2) NOT NULL,
  `recurrence_count` bigint(20) unsigned NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `previous_total` decimal(8,2) NOT NULL,
  `taxable_amount` decimal(8,2) NOT NULL,
  `balance` decimal(8,2) NOT NULL,
  `month_to_date_total` decimal(8,2) NOT NULL,
  `year_to_date_total` decimal(8,2) NOT NULL,
  `month_to_date_units` decimal(8,2) NOT NULL,
  `year_to_date_units` decimal(8,2) NOT NULL,
  `month_to_date_taxable_amount` decimal(8,2) NOT NULL,
  `year_to_date_taxable_amount` decimal(8,2) NOT NULL,
  `recurrence_period_1` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_2` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_3` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_4` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_5` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_6` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_7` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_8` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_9` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_10` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_11` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_12` int(11) NOT NULL DEFAULT 0,
  `start_date` datetime NOT NULL,
  `end_date` datetime DEFAULT NULL,
  `dedu_group_code` varchar(255) NOT NULL,
  `dedu_type_code` varchar(255) NOT NULL,
  `pay_run_period_id` bigint(20) unsigned NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_payslip_dedus_pay_run_id_foreign` (`pay_run_id`),
  KEY `pam_payslip_dedus_pay_run_period_id_foreign` (`pay_run_period_id`),
  KEY `pam_payslip_dedus_created_by_foreign` (`created_by`),
  KEY `pam_payslip_dedus_updated_by_foreign` (`updated_by`),
  KEY `pam_payslip_dedus_dedu_def_id_foreign` (`dedu_def_id`),
  KEY `pam_payslip_dedus_payslip_id_foreign` (`payslip_id`),
  KEY `pam_payslip_dedus_emp_id_foreign` (`emp_id`),
  KEY `pam_payslip_dedus_loan_id_foreign` (`loan_id`),
  CONSTRAINT `pam_payslip_dedus_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_payslip_dedus_dedu_def_id_foreign` FOREIGN KEY (`dedu_def_id`) REFERENCES `pam_dedu_defs` (`id`),
  CONSTRAINT `pam_payslip_dedus_emp_id_foreign` FOREIGN KEY (`emp_id`) REFERENCES `pam_emps` (`id`),
  CONSTRAINT `pam_payslip_dedus_loan_id_foreign` FOREIGN KEY (`loan_id`) REFERENCES `pam_loans` (`id`),
  CONSTRAINT `pam_payslip_dedus_pay_run_id_foreign` FOREIGN KEY (`pay_run_id`) REFERENCES `pam_pay_runs` (`id`),
  CONSTRAINT `pam_payslip_dedus_pay_run_period_id_foreign` FOREIGN KEY (`pay_run_period_id`) REFERENCES `pam_pay_run_periods` (`id`),
  CONSTRAINT `pam_payslip_dedus_payslip_id_foreign` FOREIGN KEY (`payslip_id`) REFERENCES `pam_payslips` (`id`),
  CONSTRAINT `pam_payslip_dedus_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_payslip_dedus` WRITE;
/*!40000 ALTER TABLE `pam_payslip_dedus` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_payslip_dedus` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_payslip_earn_defs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_payslip_earn_defs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pay_run_id` bigint(20) unsigned NOT NULL,
  `earn_def_id` bigint(20) unsigned NOT NULL,
  `earn_def_code` varchar(255) NOT NULL,
  `payslip_id` bigint(20) unsigned NOT NULL,
  `emp_id` bigint(20) unsigned NOT NULL,
  `man_number` varchar(255) NOT NULL,
  `units` decimal(8,2) NOT NULL,
  `emp_rate` decimal(8,2) NOT NULL,
  `input_amount` decimal(8,2) NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `recurrence_period_1` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_2` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_3` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_4` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_5` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_6` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_7` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_8` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_9` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_10` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_11` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_12` int(11) NOT NULL DEFAULT 0,
  `mandatory` tinyint(1) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime DEFAULT NULL,
  `earn_group_code` varchar(255) NOT NULL,
  `earn_type_code` varchar(255) NOT NULL,
  `pay_run_period_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_payslip_earn_defs_pay_run_id_foreign` (`pay_run_id`),
  KEY `pam_payslip_earn_defs_pay_run_period_id_foreign` (`pay_run_period_id`),
  KEY `pam_payslip_earn_defs_created_by_foreign` (`created_by`),
  KEY `pam_payslip_earn_defs_updated_by_foreign` (`updated_by`),
  KEY `pam_payslip_earn_defs_earn_def_id_foreign` (`earn_def_id`),
  KEY `pam_payslip_earn_defs_payslip_id_foreign` (`payslip_id`),
  KEY `pam_payslip_earn_defs_emp_id_foreign` (`emp_id`),
  CONSTRAINT `pam_payslip_earn_defs_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_payslip_earn_defs_earn_def_id_foreign` FOREIGN KEY (`earn_def_id`) REFERENCES `pam_earn_defs` (`id`),
  CONSTRAINT `pam_payslip_earn_defs_emp_id_foreign` FOREIGN KEY (`emp_id`) REFERENCES `pam_emps` (`id`),
  CONSTRAINT `pam_payslip_earn_defs_pay_run_id_foreign` FOREIGN KEY (`pay_run_id`) REFERENCES `pam_pay_runs` (`id`),
  CONSTRAINT `pam_payslip_earn_defs_pay_run_period_id_foreign` FOREIGN KEY (`pay_run_period_id`) REFERENCES `pam_pay_run_periods` (`id`),
  CONSTRAINT `pam_payslip_earn_defs_payslip_id_foreign` FOREIGN KEY (`payslip_id`) REFERENCES `pam_payslips` (`id`),
  CONSTRAINT `pam_payslip_earn_defs_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_payslip_earn_defs` WRITE;
/*!40000 ALTER TABLE `pam_payslip_earn_defs` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_payslip_earn_defs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_payslip_earns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_payslip_earns` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pay_run_id` bigint(20) unsigned NOT NULL,
  `earn_def_id` bigint(20) unsigned NOT NULL,
  `earn_def_code` varchar(255) NOT NULL,
  `payslip_id` bigint(20) unsigned NOT NULL,
  `emp_id` bigint(20) unsigned NOT NULL,
  `man_number` varchar(255) NOT NULL,
  `units` decimal(8,2) NOT NULL,
  `fixed_amount` decimal(8,2) NOT NULL,
  `recurrence_amount` decimal(8,2) NOT NULL,
  `recurrence_count` bigint(20) unsigned NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `previous_total` decimal(8,2) NOT NULL,
  `taxable_amount` decimal(8,2) NOT NULL,
  `balance` decimal(8,2) NOT NULL,
  `month_to_date_total` decimal(8,2) NOT NULL,
  `year_to_date_total` decimal(8,2) NOT NULL,
  `month_to_date_units` decimal(8,2) NOT NULL,
  `year_to_date_units` decimal(8,2) NOT NULL,
  `month_to_date_taxable_amount` decimal(8,2) NOT NULL,
  `year_to_date_taxable_amount` decimal(8,2) NOT NULL,
  `recurrence_period_1` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_2` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_3` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_4` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_5` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_6` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_7` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_8` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_9` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_10` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_11` int(11) NOT NULL DEFAULT 0,
  `recurrence_period_12` int(11) NOT NULL DEFAULT 0,
  `start_date` datetime NOT NULL,
  `end_date` datetime DEFAULT NULL,
  `earn_group_code` varchar(255) NOT NULL,
  `earn_type_code` varchar(255) NOT NULL,
  `pay_run_period_id` bigint(20) unsigned NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_payslip_earns_pay_run_id_foreign` (`pay_run_id`),
  KEY `pam_payslip_earns_pay_run_period_id_foreign` (`pay_run_period_id`),
  KEY `pam_payslip_earns_created_by_foreign` (`created_by`),
  KEY `pam_payslip_earns_updated_by_foreign` (`updated_by`),
  KEY `pam_payslip_earns_earn_def_id_foreign` (`earn_def_id`),
  KEY `pam_payslip_earns_payslip_id_foreign` (`payslip_id`),
  KEY `pam_payslip_earns_emp_id_foreign` (`emp_id`),
  CONSTRAINT `pam_payslip_earns_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_payslip_earns_earn_def_id_foreign` FOREIGN KEY (`earn_def_id`) REFERENCES `pam_earn_defs` (`id`),
  CONSTRAINT `pam_payslip_earns_emp_id_foreign` FOREIGN KEY (`emp_id`) REFERENCES `pam_emps` (`id`),
  CONSTRAINT `pam_payslip_earns_pay_run_id_foreign` FOREIGN KEY (`pay_run_id`) REFERENCES `pam_pay_runs` (`id`),
  CONSTRAINT `pam_payslip_earns_pay_run_period_id_foreign` FOREIGN KEY (`pay_run_period_id`) REFERENCES `pam_pay_run_periods` (`id`),
  CONSTRAINT `pam_payslip_earns_payslip_id_foreign` FOREIGN KEY (`payslip_id`) REFERENCES `pam_payslips` (`id`),
  CONSTRAINT `pam_payslip_earns_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_payslip_earns` WRITE;
/*!40000 ALTER TABLE `pam_payslip_earns` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_payslip_earns` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_payslips` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` bigint(20) unsigned NOT NULL,
  `pay_run_id` bigint(20) unsigned NOT NULL,
  `pay_run_period_id` bigint(20) unsigned NOT NULL,
  `gross_earnings` decimal(8,2) NOT NULL,
  `deductions` decimal(8,2) NOT NULL,
  `net_pay` decimal(8,2) NOT NULL,
  `taxable_income` decimal(8,2) NOT NULL,
  `non_taxable_income` decimal(8,2) NOT NULL,
  `tax_paid` decimal(8,2) NOT NULL,
  `leave_days` decimal(8,2) NOT NULL,
  `payed_total_year_to_date` decimal(8,2) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_payslips_created_by_foreign` (`created_by`),
  KEY `pam_payslips_updated_by_foreign` (`updated_by`),
  KEY `pam_payslips_emp_id_foreign` (`emp_id`),
  KEY `pam_payslips_pay_run_id_foreign` (`pay_run_id`),
  KEY `pam_payslips_pay_run_period_id_foreign` (`pay_run_period_id`),
  CONSTRAINT `pam_payslips_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_payslips_emp_id_foreign` FOREIGN KEY (`emp_id`) REFERENCES `pam_emps` (`id`),
  CONSTRAINT `pam_payslips_pay_run_id_foreign` FOREIGN KEY (`pay_run_id`) REFERENCES `pam_pay_runs` (`id`),
  CONSTRAINT `pam_payslips_pay_run_period_id_foreign` FOREIGN KEY (`pay_run_period_id`) REFERENCES `pam_pay_run_periods` (`id`),
  CONSTRAINT `pam_payslips_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_payslips` WRITE;
/*!40000 ALTER TABLE `pam_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_payslips` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_social_securities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_social_securities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `tax_year_id` bigint(20) unsigned NOT NULL,
  `tax_year_code` varchar(255) NOT NULL,
  `minimum_monthly_gross_income` decimal(15,2) NOT NULL,
  `employee_contribution_rate` decimal(15,2) NOT NULL,
  `employer_contribution_rate` decimal(15,2) NOT NULL,
  `employee_maximum_ceiling` decimal(15,2) NOT NULL,
  `employer_maximum_ceiling` decimal(15,2) NOT NULL,
  `employee_age_limit` int(11) NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pam_social_securities_code_unique` (`code`),
  KEY `pam_social_securities_created_by_foreign` (`created_by`),
  KEY `pam_social_securities_updated_by_foreign` (`updated_by`),
  KEY `pam_social_securities_tax_year_id_foreign` (`tax_year_id`),
  CONSTRAINT `pam_social_securities_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_social_securities_tax_year_id_foreign` FOREIGN KEY (`tax_year_id`) REFERENCES `pam_tax_years` (`id`),
  CONSTRAINT `pam_social_securities_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_social_securities` WRITE;
/*!40000 ALTER TABLE `pam_social_securities` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_social_securities` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_tax_bands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_tax_bands` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_table_id` bigint(20) unsigned NOT NULL,
  `tax_table_code` varchar(255) NOT NULL,
  `from_amount` decimal(15,2) NOT NULL,
  `to_amount` decimal(15,2) NOT NULL,
  `taxable_amount` decimal(15,2) NOT NULL,
  `tax_percentage` decimal(8,2) NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_tax_bands_tax_table_id_foreign` (`tax_table_id`),
  KEY `pam_tax_bands_created_by_foreign` (`created_by`),
  KEY `pam_tax_bands_updated_by_foreign` (`updated_by`),
  CONSTRAINT `pam_tax_bands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_tax_bands_tax_table_id_foreign` FOREIGN KEY (`tax_table_id`) REFERENCES `pam_tax_tables` (`id`),
  CONSTRAINT `pam_tax_bands_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_tax_bands` WRITE;
/*!40000 ALTER TABLE `pam_tax_bands` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_tax_bands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_tax_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_tax_tables` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_year_id` bigint(20) unsigned NOT NULL,
  `tax_year_code` int(11) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pam_tax_tables_tax_year_id_foreign` (`tax_year_id`),
  KEY `pam_tax_tables_created_by_foreign` (`created_by`),
  KEY `pam_tax_tables_updated_by_foreign` (`updated_by`),
  CONSTRAINT `pam_tax_tables_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_tax_tables_tax_year_id_foreign` FOREIGN KEY (`tax_year_id`) REFERENCES `pam_tax_years` (`id`),
  CONSTRAINT `pam_tax_tables_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_tax_tables` WRITE;
/*!40000 ALTER TABLE `pam_tax_tables` DISABLE KEYS */;
/*!40000 ALTER TABLE `pam_tax_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pam_tax_years`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pam_tax_years` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `updated_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pam_tax_years_code_unique` (`code`),
  KEY `pam_tax_years_created_by_foreign` (`created_by`),
  KEY `pam_tax_years_updated_by_foreign` (`updated_by`),
  CONSTRAINT `pam_tax_years_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `pam_tax_years_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pam_tax_years` WRITE;
/*!40000 ALTER TABLE `pam_tax_years` DISABLE KEYS */;
INSERT INTO `pam_tax_years` VALUES (2,'2023','Tax Year 2023','2023-01-01 00:00:00','2023-12-31 23:59:59','active',2,2,'2023-12-12 10:39:06','2023-12-12 10:39:06');
/*!40000 ALTER TABLE `pam_tax_years` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'Manage contribution types','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(2,'Manage contribution groups','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(3,'Manage contribution definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(4,'Manage deduction types','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(5,'Manage deduction groups','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(6,'Manage deduction definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(7,'Manage earning types','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(8,'Manage earning groups','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(9,'Manage earning definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(10,'Manage tax years','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(11,'Manage employees','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(12,'Manage pay run periods','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(13,'Manage pay runs','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(14,'Manage tax tables','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(15,'Manage pay run earning definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(16,'Manage pay run deduction definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(17,'Manage employee deduction definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(18,'Manage employee earning definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(19,'Manage payslips','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(20,'Manage payslip deductions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(21,'Manage payslip earnings','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(22,'Manage users','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(23,'Manage roles','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(24,'Manage payrolls','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(25,'View payrolls','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(26,'View contribution types','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(27,'View contribution groups','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(28,'View contribution definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(29,'View deduction types','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(30,'View deduction groups','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(31,'View deduction definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(32,'View earning types','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(33,'View earning groups','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(34,'View earning definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(35,'View tax years','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(36,'View employees','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(37,'View pay run periods','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(38,'View pay runs','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(39,'View tax tables','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(40,'View pay run earning definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(41,'View pay run deduction definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(42,'View employee deduction definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(43,'View employee earning definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(44,'View payslips','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(45,'View payslip deductions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(46,'View payslip earnings','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(47,'View users','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(48,'View roles','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(49,'View tax table definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(50,'Manage tax table definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(51,'View tax year definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(52,'Manage tax year definitions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(53,'Show claims','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(54,'Submit claims','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(55,'Approve claims','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(56,'Run payroll','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(57,'View Reports','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(58,'View historical data','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(59,'Manage deductions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(60,'View deductions','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(61,'Manage earnings','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(62,'View earnings','web','2023-12-01 12:08:22','2023-12-01 12:08:22');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,1),(7,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(24,1),(25,1),(26,1),(27,1),(28,1),(29,1),(30,1),(31,1),(32,1),(33,1),(34,1),(35,1),(36,1),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(43,1),(44,1),(45,1),(46,1),(47,1),(48,1),(48,2),(49,1),(50,1),(51,1),(52,1),(53,1),(54,1),(55,1),(56,1),(57,1),(58,1),(59,1),(60,1),(61,1),(62,1);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin','web','2023-12-01 12:08:22','2023-12-01 12:08:22'),(2,'User','web','2023-12-01 12:08:22','2023-12-01 12:08:22');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `payrolls` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'mulima.chibuye','Mulima Chibuye','mulima.chibuye@unza.zm','1','2023-11-10 09:21:48','$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi','hZyU9rR3Sz','2023-11-10 09:21:48','2023-11-10 09:21:48',NULL),(2,'simon.chiwamba','Simon Chiwamba','simon.chiwamba@unza.zm','1','2023-11-10 09:21:48','$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi','XPxdC6oJCw','2023-11-10 09:21:48','2023-11-10 09:21:48',NULL),(3,'mmwenya@unza.zm','Makasa Mwenya','mmwenya@unza.zm','1','2023-11-10 09:21:48','$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi','aOrq8k8r2EMETtuaRbc8zOS5xVLh1zggNB20kh9K6dapipQ5FSkLcwx1rosI','2023-11-10 09:21:48','2023-11-13 08:54:20',NULL),(4,'demo.user','Demo User','demo@unza.zm','1','2023-11-10 09:21:48','$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi','MZkwuoPazbQnOREhs9c0QOdPBhldaxxAwb5qtVGcf3Ff7jUOQoFYztcYVOmo','2023-11-10 09:21:48','2023-11-10 09:21:48',NULL),(6,'test@unza.zm','test','test@unza.zm','1',NULL,'$2y$10$wEEVBH8fA871Sn/mLkMP3esRqHE5lQc.Tl8BXAjkmnSgtLsNfP66q',NULL,'2023-11-13 08:56:22','2023-11-13 08:56:22',''),(7,'mmusonda@unza.zm','Martin Musonda','mmusonda@unza.zm','1',NULL,'$2y$10$IEPVIS6s6auCkcbCZ04rU.rJPRF6xByU537BSeJO8SIBet/gcgmpq',NULL,'2023-11-13 08:56:53','2023-11-13 08:56:53','0001'),(8,'anderson.nkhoma@unza.zm','Anderson Nkhoma','anderson.nkhoma@unza.zm','1',NULL,'$2y$10$7yiZOseWCoHXxG3tyuOz5.A3W5XrB0wiW9wO1T5TZwa7MfDNQYqSC',NULL,'2023-11-14 03:28:15','2023-11-14 03:28:15',''),(9,'gmulenga@unza.zm','Mubanga G. Mulenga','gmulenga@unza.zm','1',NULL,'$2y$10$UVoRGOLOQen4ZJM46qXpcOaVXZ4fGI4vwVt1DDhZvcrHO8qUcc0ay',NULL,'2023-11-14 03:30:23','2023-11-14 03:30:23',''),(10,'csichilima@unza.zm','Chipefwe Sichilima','csichilima@unza.zm','1',NULL,'$2y$10$CAllT6WJMwdSFC2qsXr5zecsZuhAc8JLCisrSDAckIx/94wgBY0mW',NULL,'2023-11-14 03:35:26','2023-11-14 03:35:26',''),(11,'lennox.chiabi@unza.zm','Lennox Chiabi','lennox.chiabi@unza.zm','1',NULL,'$2y$10$Iymi7wnllANXqG9owL8wS.LG3VMhzMcplgbYZBOAxpnDSLQLJJoiO',NULL,'2023-11-14 03:36:50','2023-11-14 03:36:50',''),(12,'ernest.simutowe@unza.zm','Ernest Simutowe','ernest.simutowe@unza.zm','1',NULL,'$2y$10$8lKECcEbs3Z159GX8U8fGef/XR0VLIterph6PtT.DL5539g1llP4G',NULL,'2023-11-14 03:38:30','2023-11-14 03:38:30',''),(13,'mabvuto.mazuko@unza.zm','Mabvuto Mazuko','mabvuto.mazuko@unza.zm','1',NULL,'$2y$10$c6B/.R8RznYcMd7dPFXhbOkVffQAA6nIk.3A420kLBskYyd6w2cXu',NULL,'2023-11-14 03:40:45','2023-11-14 11:08:44','[\"0001\"]'),(14,'annie.chitoshi@unza.zm','Annie Chitoshi','annie.chitoshi@unza.zm','1',NULL,'$2y$10$jqhCZn5qjMvmqjqXcjQ0D.xqgxMMU0ugEKQ6Nqr5zvEoXVIm/Rtru',NULL,'2023-11-14 03:55:07','2023-11-14 03:55:07',''),(15,'emmah.kamanga@unza.zm','Emma Kamanga','emmah.kamanga@unza.zm','1',NULL,'$2y$10$.D4VJYZ/H7tZWe42ATE.yugcFqoQxvLtzJ7to/AIGabZbCEFf41Ou',NULL,'2023-11-14 04:08:39','2023-11-14 04:08:39',''),(16,'mutinta.muponda@unza.zm','Mutinta Muponda','mutinta.muponda@unza.zm','1',NULL,'$2y$10$.vhHe4LCUNftwPgzZo8wvefLOcJqsqZP.WUeAasWFkIgSBOjb4cgi',NULL,'2023-11-14 04:09:31','2023-11-14 04:09:31',''),(17,'evelyn.nyirenda@unza.zm','Evelyn Nyirenda','evelyn.nyirenda@unza.zm','1',NULL,'$2y$10$.qJum/aC.m0Of9WPAebVze39DJ1BROowfK.uZwK/5C0ZZna6pQJuC',NULL,'2023-11-14 04:10:15','2023-11-14 04:10:15',''),(18,'another@unza.zm','another user','another@unza.zm','1',NULL,'$2y$10$oghJM7fKHRMmvrMHP.h4qOq6NLucsPLmXoXNttt5Hm5itAD/RWRTq',NULL,'2023-11-27 12:04:59','2023-11-27 12:04:59',NULL),(19,'stevensokoni4002@gmail.com','Steven Sokoni','stevensokoni4002@gmail.com','1',NULL,'$2y$10$ONohGY6PSuR81qFcQOGtvur2LkMJxm.cIsQYFK5yIN5OTahw/LLXa',NULL,'2023-11-28 07:43:45','2023-11-28 07:43:45',NULL),(20,'test1@unza.zm','test1','test1@unza.zm','1',NULL,'$2y$10$zGuHyXpOkuIH5NoRJ/mxz.whZfTU.GTBPkNoQJFwGueEpp.ceKaf6',NULL,'2023-12-12 06:22:07','2023-12-12 06:22:07',NULL),(21,'test2@unza.zm','test2','test2@unza.zm','1',NULL,'$2y$10$24qjaI/jZmImVE6hcSqCHunW3YZEV6JEiFqwSsZDUV/SRpfy43gaS',NULL,'2023-12-12 06:22:38','2023-12-12 06:22:38',NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

